<div class="step-content register-step" step-order="3" data-chapter="2" style="{{ $start_point !== 3 ? 'display: none;' : '' }}">
    <h2 class="font-HeptaSlab font-extrabold text-6xl mb-2.5">Chapitre 2</h2>
    <h4 class="font-HeptaSlab font-medium text-3xl mb-2.5">Mon résumé</h4>
    <p class="text-sm font-medium mb-7">
        Voilà ! Nous y sommes !
        <br />
        Première étape d’un long parcours sans embuche qui va nous permettre de faire connaissance, de t’intégrer à notre communauté, et de te faire réaliser ton rêve d’édition. Commence par nous donner quelques informations sur ton texte.
    </p>

    <form class="py-2.5">
        <div class="mb-4 grid grid-cols-2 gap-10">
            <div class="input-group">
                @include('web.components.forms.text', ['id' => 'story_title', 'name' => 'story_title', 'label' => 'Titre du récit', 'value' => isset($user) && $user->userAbstract ? $user->userAbstract->storyTitle : '', 'placeholder' => '', 'required' => true, 'readOnly' => isset($user) && $user->userAbstract ? true : false])
            </div>
            <div class="input-group">
                @include('web.components.forms.select', ['id' => 'literary_form', 'name' => 'literary_form', 'label' => 'Forme littéraire', 'value' => isset($user) && $user->userAbstract ? $user->userAbstract->literaryForm : '', 'placeholder' => '', 'required' => true, 'readOnly' => isset($user) && $user->userAbstract ? true : false, 'datas' => $literaryFormList])
            </div>
        </div>
        <div class="mb-4 grid grid-cols-2 gap-10">
            <div class="input-group">
                @include('web.components.forms.text', ['id' => 'register', 'name' => 'register', 'label' => 'Registre (facultatif)', 'value' => isset($user) && $user->userAbstract ? $user->userAbstract->register : '', 'placeholder' => '', 'required' => false, 'readOnly' => isset($user) && $user->userAbstract ? true : false])
            </div>
            <div class="input-group">
                @include('web.components.forms.text', ['id' => 'theme', 'name' => 'theme', 'label' => 'Thème (facultatif)', 'value' => isset($user) && $user->userAbstract ? $user->userAbstract->theme : '', 'placeholder' => '', 'required' => false, 'readOnly' => isset($user) && $user->userAbstract ? true : false, ])
            </div>
        </div>
        <div class="mb-8">
            <label class="block text-sm font-medium mb-2.5">Résumé du récit</label>
            <div class="p-5 shadow-2xl rounded-lg bg-purple text-white text-sm font-medium">
                Rédige pour nous, pour nous aider à définir comment nous allons présenter ton texte, un résumé de quelques phrases seulement, dans lequel :
                <br />
                <br />
                • Tu le présenteras, en nous faisant part notamment des motifs qui t’ont conduits à l’écrire
                <br />
                • Tu le résumeras en nous faisant découvrir le personnage principal, ce qu’il fait, où, quand, avec qui, comment, pourquoi, dans quel environnement
                <br />
                • En précisant quel genre tu utilises et pourquoi, à quel registre appartient ton texte, et quel thème tu as souhaité aborder.
            </div>
        </div>
        <div>
            <div class="p-5 rounded-lg bg-white text-sm font-medium">
                <textarea class="mb-14 w-full focus:outline-none abstract-text" name="text" rows="5" placeholder="Raconte-nous la raison de ton écriture (facultatif) et dépose le fichier contenant ton manuscrit" {{ isset($user) && $user->userAbstract ? 'readOnly' : '' }}>{{ isset($user) && $user->userAbstract && $user->userAbstract->text ? $user->userAbstract->text : '' }}</textarea>
                <button type="button" class="rounded-lg px-5 py-2.5 bg-gray-200 text-sm font-medium file-button" file-input-id="abstract-file">Ajouter des fichiers</button>
                <input class="input-file hidden" name="abstract_file" id="abstract-file" type="file" accept=".doc,.docx,.pdf" required>
                <span id="abstract-file-label" class="ml-2 hidden"></span>
            </div>
        </div>
    </form>
    <div class="errors-container"></div>
    @include('web.components.register.step-nav', ['step' => 3, 'next_disabled' => Auth::check() && $user->userAbstract && $user->userAbstract->isApproved === null ? true : false])
</div>
