@if (count($testimonies) > 0)
<section id="testimony-wrapper" class="py-14 md:py-24 sm:pb-24">
    <div class="container">
        <!-- Begin Slider -->
        <div class="md:py-14 slider quote-message md:-mx-5">
            @foreach($testimonies as $testimony)
            <div class="text-center py-12 px-10 md:px-48">
                <h2 class="font-extrabold text-4xl font-HeptaSlab mb-6">Nos auteurs nous apprécient</h2>
                <div class="text-sm mb-8">{!! $testimony->content !!}</div>
                <span class="text-sm font-bold text-light-purple">{{ $testimony->author }}</span>
            </div>
            @endforeach
        </div>
        <!-- End Slider -->
    </div>
</section>
@endif

@section('js')
    @parent
    <script>
        $("#testimony-wrapper .slider").slick({
            infinite: false,
            slidesToShow: 1,
            dots: true,
            arrows: false,
        });
    </script>
@endsection