@if (count($collections) > 0)
<section id="collections-wrapper" class="py-14 md:py-24">
    <div class="container">
        <h2 class="font-HeptaSlab font-extrabold text-4xl md:text-left text-center">Collections</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-16 md:gap-10 py-8">
            @foreach($collections as $index => $collection)
                @php
                    if ($index === 0) $clipStyle = "clip-path: polygon(0% 3%, 100% 0%, 95% 100%, 3% 99%);";
                    else if ($index === 1) $clipStyle = "clip-path: polygon(0% 3%, 100% 0%, 90% 100%, 3% 99%);";
                    else $clipStyle = "clip-path: polygon(2% 0%, 100% 3%, 94% 99%, 3% 100%);";
                @endphp
                <div class="text-center flex justify-between items-center flex-col mt-10">
                    <div class="bg-white p-14 mb-10" style="{{ $clipStyle }}">
                        <img src="{{ $collection->image('logo', 'default') }}" class="mb-5" alt="{{ $collection->title }}" loading="lazy" />
                        <h3 class="font-HeptaSlab text-2xl font-extrabold text-center mb-5">{{ $collection->title }}</h3>
                        <div class="text-center">
                            {!! $collection->content !!}
                        </div>
                    </div>
                    <a href="{{ route('web.collections.show', [$collection->id]) }}" class="bg-primary text-white px-4 py-3 rounded-3xl font-bold">Explorer la collection</a>
                </div>
            @endforeach
        </div>

        <div class="md:w-3/6 w-full border-purple-500 border-b mx-auto md:mt-24 mt-8">
        </div>

    </div>
    <div class="container quote">
        <div class="text-center mt-16 py-12 quote-message">
            <p class="font-HeptaSlab md:text-4xl text-3xl font-medium md:mb-4 mb-10 px-5 md:px-8">« Écrire un roman, c'est savoir que chaque mot fait aussi partie d'un immense trésor.»</p>
            <span class="md:text-2xl text-xl font-HeptaSlab font-medium mt-">Marie-Claire Blais - Tête blanche</span>
        </div>
    </div>
</section>
@endif