@if (isset($collections) && count($collections) > 0)
@php
    $starterIndex = $collections->search(function($collection) use ($currentCollectionId) {
        return $collection->id === $currentCollectionId;
    });
@endphp
<section id="collection-slider" class="bg-purple py-16">
    <div class="container">
        <!-- Begin Slider -->
        <div class="py-14 md:px-52 slider md:-mx-5">
            @foreach ($collections as $collection)
            <div class="collection-slider-item" data-collection-id="{{ $collection->id }}">
                <div class="flex items-center justify-center md:justify-start flex-wrap md:flex-nowrap">
                    <img src="{{ $collection->image('logo', 'default') }}" class="hidden md:block mb-8 md:mb-0 md:mr-8" width="270px" height="auto" alt="{{ $collection->title }}" loading="lazy" />
                    <div class="text-white text-center md:text-left">
                        <h5 class="font-bold mb-1 uppercase">Collection</h5>
                        <h2 class="font-HeptaSlab font-extrabold text-4xl mb-5">{{ $collection->title }}</h2>
                        <div class="text-sm font-medium mt-4 mb-6">
                            {!! $collection->summary !!}
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        <!-- End Slider -->
        <ul class="custom-slick-arrows">
            <li class="custom-prev-button"></li>
            <li class="custom-next-button"></li>
        </ul>
    </div>
</section>

@section('js')
    @parent
    <script>
        const starterIndex = "{{ $starterIndex }}";
        $("#collection-slider .slider").slick({
            infinite: false,
            slidesToShow: 1,
            prevArrow: $('#collection-slider .custom-prev-button'),
            nextArrow: $('#collection-slider .custom-next-button'),
            initialSlide: parseInt(starterIndex),
        });
        $('#collection-slider .slider').on('afterChange', function(event, slick, currentSlide, nextSlide){
            const collectionId = $(slick.$slides.get(currentSlide)).find('.collection-slider-item').data('collection-id');
            ajaxGetExtraits(collectionId);
            
        });
    </script>
@endsection

@endif
