@extends('web.layouts.default', ['page' => 'register'])

@section('page_name', 'register')

@section('meta')
<title>{{ config('app.name') }}</title>
<meta name="title" content="{{ config('app.name') }}">
@endsection

@section('content')
@php
    $start_point = 0;
    if (Auth::check() && $user->step === 'chapter1') {
        $start_point = 2;
    } else if (Auth::check() && $user->step === 'chapter2') {
        if ($user->userAbstract && $user->userAbstract->isApproved === false) {
            $start_point = 11;
        }
        else if ($user->userAbstract && $user->userAbstract->isApproved === true) {
            $start_point = 4;
        } else if ($user->userAbstract && $user->userAbstract->isApproved === null) {
            $start_point = 4;
        }
    } else if (Auth::check() && $user->step === 'chapter3') {
        if ($user->userManuscript && $user->userManuscript->isApproved === false) {
            $start_point = 12;
        }
        else if ($user->userManuscript && $user->userManuscript->isApproved === true) {
            $start_point = 7;
        } else if ($user->userManuscript && $user->userManuscript->isApproved === null) {
            $start_point = 7;
        }
    } else if (Auth::check() && $user->step === 'chapter4') {
        $start_point = 9;
    }
@endphp
<section id="register" class="bg-light-yellow md:py-24 py-10">
    <div class="container">
        <div id="step-container" class="flex flex-wrap items-start">
            @include('web.components.register.step-sidebar')
            @include('web.partials.register.intro')
            @include('web.partials.register.chapter1')
            @include('web.partials.register.chapter1-success')
            @include('web.partials.register.chapter2')
            @include('web.partials.register.chapter2-success')
            @include('web.partials.register.chapter2-refuse')
            @include('web.partials.register.chapter3')
            @include('web.partials.register.chapter3-intro')
            @include('web.partials.register.chapter3-success')
            @include('web.partials.register.chapter3-refuse')
            @include('web.partials.register.chapter4')
            @include('web.partials.register.chapter4-success')
            @include('web.partials.register.chapter5')
        </div>
    </div>
</section>

@endsection
@section('hidden_elements')
@include('web.layouts.modal', ['data_modal' => 'protection-method', 'class' => 'modal-lg'])
@endsection
@section('js')
<script src="{{ asset('js/register.js') }}"></script>
@endsection
