@extends('web.layouts.default', ['page' => 'about'])

@section('page_name', 'about')

@section('meta')
<title>{{ config('app.name') }}</title>
<meta name="title" content="{{ config('app.name') }}">
@endsection

@section('content')

<section class="bg-purple">
    <div class="container">
        <div class="py-10 md:p-24">
            <p class="text-3xl md:text-6xl text-white font-HeptaSlab font-extrabold">Lettre aux parents</p>
            <div class="content">
                <p class="text-white mt-12 md:mt-24 mb-8 md:mb-16 md:px-52 italic font-medium quote-message">
                    Chers parents,<br/><br/>

                    Voici Stencil.<br/><br/>

                    Une maison d’édition créée par Marie que j’accompagne dans son aventure.<br/><br/>

                    Ensemble, nous avons le souhait qu’elle soit animée par vos enfants.<br/><br/>

                    Qu’ils soient auteurs ou lecteurs, correcteurs ou critiques, parrains, ou groupies, chacun sera un grand acteur de ce petit projet dont nous leur confions la mission de le faire grandir en même temps qu’eux.<br/><br/>

                    Ici, les œuvres que nous souhaitons accueillir seront petites ou plus grandes, seront des récits, ou des témoignages, des réflexions, des revendications peut-être, etc, écrits par nos enfants.<br/><br/>

                    Notre ambition est d’accompagner celles et ceux avec le désir d’écrire, d’encourager, de corriger aussi, de suggérer, de guider, de soutenir, jusqu’à l’accomplissement de leur ouvrage.<br/><br/>

                    Notre bonheur sera le leur.<br/><br/> Celui d’avoir pu mener à terme un projet, long, complexe, d’avoir su les faire s’accrocher jusqu’à l’acharnement peut-être pour certains, pour qu’au final, ils soient heureux d’avoir réalisé un travail qui n’appartiendra à personne d’autre qu’à eux.<br/><br/>

                    L’objet de ce projet est bien d’inciter nos enfants à écrire, et leurs camarades, se sentant pour l’instant plus proches d’eux que de Stendhal, à les lire. Mais il est aussi un moyen de communication entre les générations.<br/><br/>

                    Vous, qui comme moi, êtes le parent d’un enfant qui écrit, vous savez sa pudeur à vous dévoiler ses récits qui pourtant, décrivent intimement son monde tel qu'il le perçoit et le vit.<br/><br/> 

                    Alors, en découvrant ce que nos enfants vont nous offrir, nous les rejoindrons et confrontés en douceur à tout ce qu’ils exprimeront, peut-être pourrons-nous partager un dernier petit bout de vie ensemble, avant de les accueillir dans notre monde d’adultes.<br/><br/>

                    Avec Marie, nous sommes déjà très contents que vous soyez venus faire un petit tour sur notre site pour nous découvrir.<br/><br/>

                    Je vous invite à poursuivre votre visite vers le parcours d’édition que nous proposons à vos enfants.<br/><br/>

                    Vous y avez une place de choix.<br/><br/>

                    Au plaisir de vous accueillir prochainement parmi nous.<br/><br/>
                </p>
                <div class="h-px w-64 bg-white md:ml-52 opacity-20 mb-8 md:mb-16"></div>
                <p class="font-PermanentMarker text-white md:ml-52 text-3xl">Pierre Guillem</p>
            </div>
        </div>
    </div>
</section>

@endsection