$(document).ready(function() {
	$.validator.addMethod(
		"customDate",
		function(value, element) {
			return value.match(/^\d\d?\/\d\d?\/\d\d\d\d$/);
		},
		"Veuillez saisir une date au format dd/mm/yyyy"
	);

	$.validator.addMethod(
		"checkUsername",
		function(value, element, param) {
			const lastName = $("input[name='" + param + "']").val();
			return lastName !== "" && value.toLowerCase().indexOf(lastName.toLowerCase()) <= -1;
		},
		"Le pseudonyme ne peut pas contenir le nom de famille"
	);

	$.validator.addMethod(
		"ageOver",
		function(value, element) {
			if (value.match(/^\d\d?\/\d\d?\/\d\d\d\d$/)) {
				const arrayOfStrings = value.split("/");
				const date = new Date(arrayOfStrings[2], arrayOfStrings[1]-1, arrayOfStrings[0]);
				const today = new Date();
				const age = Math.floor((today - date) / (365.25 * 24 * 60 * 60 * 1000));
				return age <= 20;
			}
		},
		"Vous ne devez pas avoir plus de 20 ans"
	);

	$('.register-step[step-order="1"] form').validate({
		rules: {
			first_name: {
				required: true
			},
			last_name: {
				required: true,
			},
			email: {
				required: true,
				email: true,
			},
			birth_date: {
				required: true,
				customDate: true,
				ageOver: true,
			},
			description: {
				maxlength: 191,
			},
			password: {
				required: true,
				minlength: 8,
			},
		},
		messages: {
			first_name: {
				required: "Le prénom est requis"
			},
			last_name: {
				required: "Le nom de famille est requis",
			},
			email: {
				required: "L'e-mail est requis",
				email: "Email invalide",
			},
			birth_date: {
				required: "La date de naissance est requise"
			},
			description: {
				maxlength: "Le texte de description ne peut contenir plus de 191 caractères",
			},
			password: {
				required: "Mot de passe requis",
				minlength: "La longueur minimale est de 8",
			},
		},
		errorPlacement: function(error, element) {
			const placement = $(element).data('error');
			if (placement) {
			  $(placement).append(error)
			} else {
			  error.insertAfter(element);
			}
		}
	});

	$('.register-step[step-order="3"] form').validate({
		rules: {
			story_title: {
				required: true
			},
			literary_form: {
				required: true,
			},
		},
		messages: {
			story_title: {
				required: "Le titre de l'étage est requis"
			},
			literary_form: {
				required: "La forme littéraire est requise",
			},
		},
		errorPlacement: function(error, element) {
			const placement = $(element).data('error');
			if (placement) {
			  $(placement).append(error)
			} else {
			  error.insertAfter(element);
			}
		}
	});

	$('.register-step[step-order="8"] form').validate({
		rules: {
			contact_person_email: {
				required: function (element) {
					return !$('.register-step[step-order="8"] form input[name="user_age"]').val() < 18;
				},
				email: true,
			},
			phone: {
				minlength: 10,
				maxlength: 10,
			},
			accept_contact: {
				required: function (element) {
					return !$('.register-step[step-order="8"] form input[name="user_age"]').val() < 18;
				},
			}
		},
		messages: {
			contact_person_email: {
				required: "L'e-mail est requis",
				email: "Format adresse mail incorrecte",
			},
			phone: {
				matches: "Format numéro de téléphone incorrecte",
				minlength: "Format numéro de téléphone incorrecte",
				maxlength: "Format numéro de téléphone incorrecte",
			},
			accept_contact: {
				required: "",
			}
		},
		errorPlacement: function(error, element) {
			const placement = $(element).data('error');
			if (element.attr("name") === "age_over") {
				$("#age-error-container").append(error);
			} else if (placement) {
			  	$(placement).append(error);
			} else {
			  error.insertAfter(element);
			}
		}
	});

	$('body').on('click', '.next-step-btn', function(event){
		if ($(this).hasClass('loading')) return;

		let current_step_container = $(this).parents('.register-step');
		let step = parseInt(current_step_container.attr('step-order'));
		let auth_status = $(this).data('auth-step');

		if (step === 1) {  // Chapter 1
			if (auth_status === 'unauthorized') {
				if ($('.register-step[step-order="1"] form').valid()) {
					ajaxRegister();
				}
			} else {
				nextStep(step, step + 2);
			}
		} else if (step === 3) {
			if (auth_status === 'chapter2' || auth_status === 'chapter3' || auth_status === 'chapter4') {
				nextStep(step, step + 2);
			} else {
				if ($('.register-step[step-order="3"] form').valid()) {
					if ($('#abstract-file')[0].files.length === 0 && $('.register-step[step-order="3"] .abstract-text').val() === '') {
						let errors_container = $('.register-step[step-order="3"]').find('.errors-container');
						errors_container.empty();
						displayFormError(errors_container, 'Le manuscrit est requis');
					} else {
						ajaxSubmitAbstract();
					}
				}
			}
		} else if (step === 6) {
			if (auth_status === 'chapter3' || auth_status === 'chapter4') {
				nextStep(step, step + 2);
			} else if ($('#manuscript-file')[0].files.length === 0) {
				let errors_container = $('.register-step[step-order="6"]').find('.errors-container');
				errors_container.empty();
				displayFormError(errors_container, 'Le manuscrit est requis');
			} else {
				ajaxSubmitManuscript();
			}
		} else if (step === 8){
			if (auth_status === 'chapter4') {
				nextStep(step);
			} else {
				if ($('.register-step[step-order="8"] form').valid()) {
					ajaxSubmitParentsContact();
				}
			}
		} else {
			nextStep(step);
		}
	});

	$('body').on('click', '.prev-step-btn', function(event){
		let current_step_container = $(this).parents('.register-step');
		let step = parseInt(current_step_container.attr('step-order'));
		let auth_status = $(this).data('auth-step');

		if (step === 3) {
			if (auth_status === 'chapter1' || auth_status === 'chapter2' || auth_status === 'chapter3' || auth_status === 'chapter4') {
				previousStep(step, step - 2);
			} else {
				previousStep(step);
			}
		} else if (step === 5) {
			if (auth_status === 'chapter2' || auth_status === 'chapter3' || auth_status === 'chapter4') {
				previousStep(step, step - 2);
			} else {
				previousStep(step);
			}
		} else if (step === 8){
			if (auth_status === 'chapter3' || auth_status === 'chapter4') {
				previousStep(step, step - 2);
			} else {
				previousStep(step);
			}
		} else {
			previousStep(step);
		}
	});
});