function getErrors(data) {
	let errors = [];
	if(data.responseJSON){
		let data_errors = data.responseJSON.errors;
		if(data_errors == undefined) {
			errors.push({type: "erreur", messages: [data.responseJSON.message]});
		} else {
			$.each(data_errors, function(key, value) {
				errors.push({type: key, messages: value});
			});
		}
	}
	return errors;
}

function isSuccessStatus(status) {
	return status == 200 || status == 201 || status == 204;
}

function ajaxRegister(){
	let params = [];

	$('.register-step[step-order="1"] input, .register-step[step-order="1"] select').each(function(){
		if($(this).attr('type') != 'checkbox' && $(this).attr('type') != 'radio'){
			if($(this).val() != undefined && $(this).val() != "" && $(this).val() != 0){
				params[$(this).attr('name')] = $(this).val();
			}
		} else {
			if($(this).is(':checked')){
				if(params[$(this).attr('name')] == undefined){
					params[$(this).attr('name')] = "";
				}
				if($(this).attr('type') == 'checkbox' && $(this).data('field-type') != 'string'){
					if(params[$(this).attr('name')].length > 0){
						params[$(this).attr('name')].push($(this).val());
					} else {
						params[$(this).attr('name')] = [$(this).val()];
					}
				} else {
					params[$(this).attr('name')] = $(this).val();
				}
			}
		}
	});
	params = Object.assign({}, params);	
	ajax_locked = true;
	$('.next-step-btn').addClass('loading');
	ajaxCall('/register', 'POST', params, 'responseRegister');
	
}

function responseRegister(data){
	let errors = getErrors(data);
	let errors_container = $('.register-step[step-order="1"]').find('.errors-container');
	$('.next-step-btn').removeClass('loading');
	errors_container.empty();
	if(isSuccessStatus(data.status)){
		location.reload();
	} else {
		for(let i = 0; i < errors.length; i++) {
			displayFormError(errors_container, errors[i]);
		}
	}
}

function ajaxLogin(){
	let form = $('#login');
	let params = {
		email: form.find("input#email").val(),
		password: form.find("input#password").val()
	};

	ajax_locked = true;
	$('.login-btn').addClass('loading');
	ajaxCall('/login', 'POST', params, 'responseLogin');
}

function responseLogin(data) {
	let errors = getErrors(data);
	let errors_container = $("#login").find('.errors-container');

	errors_container.empty();
	if(isSuccessStatus(data.status)){
		location.reload();
	} else {
		for(let i = 0; i < errors.length; i++){
			displayFormError(errors_container, errors[i]);
		}
	}
}

function ajaxSubmitAbstract() {
	let params = [];

	$('.register-step[step-order="3"] input, .register-step[step-order="3"] select, .register-step[step-order="3"] textarea').each(function(){
		if($(this).attr("type") !== 'file'){
			params[$(this).attr('name')] = $(this).val();
		}
	});
	const formData = new FormData();
	params = Object.assign({}, params);
	
	for (let key in params) {
		formData.append(key, params[key]);
	}
	formData.append('abstract_file', $('#abstract-file')[0].files[0]);
	ajax_locked = true;
	$('.next-step-btn').addClass('loading');
	ajaxCall('/submit-abstract', 'POST', formData, 'responseSubmitAbstract', true);
}

function responseSubmitAbstract(data){
	let errors = getErrors(data);
	let errors_container = $('.register-step[step-order="3"]').find('.errors-container');
	$('.next-step-btn').removeClass('loading');
	errors_container.empty();
	if(isSuccessStatus(data.status)){
		window.location.reload();
	} else {
		for(let i = 0; i < errors.length; i++) {
			displayFormError(errors_container, errors[i]);
		}
	}
}


function ajaxRefuseAbstract() {
	ajax_locked = true;
	ajaxCall('/refuse-abstract', 'POST', null, 'responseRefuseAbstract', true);
}


function responseRefuseAbstract(data){
	if(isSuccessStatus(data.status)){
		window.location.reload();
	}
}


function ajaxSubmitManuscript() {
	const formData = new FormData();
	formData.append('manuscript_file', $('#manuscript-file')[0].files[0]);

	ajax_locked = true;
	$('.next-step-btn').addClass('loading');
	ajaxCall('/submit-manuscript', 'POST', formData, 'responseSubmitManuscript', true);
}

function responseSubmitManuscript(data){
	let errors = getErrors(data);
	let errors_container = $('.register-step[step-order="6"]').find('.errors-container');
	$('.next-step-btn').removeClass('loading');
	errors_container.empty();
	if(isSuccessStatus(data.status)){
		window.location.reload();
	} else {
		for(let i = 0; i < errors.length; i++) {
			displayFormError(errors_container, errors[i]);
		}
	}
}


function ajaxRefuseManuscript() {
	ajax_locked = true;
	ajaxCall('/refuse-manuscript', 'POST', null, 'responseRefuseManuscript', true);
}


function responseRefuseManuscript(data){
	if(isSuccessStatus(data.status)){
		window.location.reload();
	}
}

function ajaxSubmitParentsContact() {
	let params = [];

	$('.register-step[step-order="8"] input').each(function(){
		if($(this).attr('type') != 'checkbox' && $(this).attr('type') != 'radio'){
			params[$(this).attr('name')] = $(this).val();
		} else {
			if(params[$(this).attr('name')] == undefined){
				params[$(this).attr('name')] = "";
			}

			if($(this).is(':checked')){
				params[$(this).attr('name')] = 1;
			} else {
				params[$(this).attr('name')] = 0;
			}
		}
	});
	params = Object.assign({}, params);	
	ajax_locked = true;
	$('.next-step-btn').addClass('loading');
	ajaxCall('/submit-parents-contact', 'POST', params, 'responseSubmitParentsContact');
}

function responseSubmitParentsContact(data){
	let errors = getErrors(data);
	let errors_container = $('.register-step[step-order="8"]').find('.errors-container');
	$('.next-step-btn').removeClass('loading');
	errors_container.empty();
	if(isSuccessStatus(data.status)){
		window.location.reload();
	} else {
		for(let i = 0; i < errors.length; i++) {
			displayFormError(errors_container, errors[i]);
		}
	}
}

function ajaxGetTestimonials(collectionId) {
	let params = [];
	params['collection_id'] = collectionId;
	params = Object.assign({}, params);	
	ajax_locked = true;
	$("#collection-story").fadeOut("fast");
	ajaxCall('/collections/' + collectionId + '/testimonials', 'POST', params, 'responseGetTestimonials');
}

function responseGetTestimonials(data) {
	let errors = getErrors(data);
	if(isSuccessStatus(data.status)){
		const html = JSON.parse(data.responseText).html;
		$('#collection-story .container').html(html).promise().done(function() {
			$("#collection-story").fadeIn("fast");
			$("#collection-story .slider").slick({
				infinite: false,
				slidesToShow: 1,
				dots: true,
				arrows: false,
			});
		});
	} else {
		for(let i = 0; i < errors.length; i++) {
			console.log(errors[i]);
		}
	}
}

function submitContactEmail(element) {
	if ($(element).hasClass('loading')) return;
	if ($("#phone-app form").valid()) {
		let params = [];

		$('#phone-app form input').each(function(){
			if($(this).attr('type') != 'checkbox' && $(this).attr('type') != 'radio'){
				if($(this).val() != undefined && $(this).val() != "" && $(this).val() != 0){
					params[$(this).attr('name')] = $(this).val();
				}
			}
		});

		params = Object.assign({}, params);	
		ajax_locked = true;
		$(element).addClass('loading');
		ajaxCall('/submit-contact-email', 'POST', params, 'responseSubmitContactEmail');
	}
}

function responseSubmitContactEmail(data){
	let errors = getErrors(data);
	let errors_container = $('#phone-app form').find('.errors-container');
	$('#phone-app form button').removeClass('loading');
	errors_container.empty();
	if(!isSuccessStatus(data.status)){
		for(let i = 0; i < errors.length; i++) {
			displayFormError(errors_container, errors[i]);
		}
	}
}

function ajaxForgotPassword(){
	let form = $('#forgot-password');
	let params = {
		email: form.find("input#forgot-email").val()
	};

	ajax_locked = true;
	$('#forgot-password button').addClass('loading');
	ajaxCall('/password/email', 'POST', params, 'responseForgotPassword');
}

function responseForgotPassword(data){
	let errors = getErrors(data);
	let success_container = $("#forgot-password").find('.success-container');
	let errors_container = $("#forgot-password").find('.errors-container');

	success_container.empty();
	errors_container.empty();
	$('#forgot-password button').removeClass('loading');
	if(isSuccessStatus(data.status)){
		displayFormSuccess(success_container, $.parseJSON(data.responseText).message);
	} else {
		for(let i = 0; i < errors.length; i++){
			displayFormError(errors_container, errors[i]);
		}
	}
}

function ajaxResetPassword(){
	let form = $('#reset-password');
	let params = {
		token: form.find("input#token-reset").val(),
		email: form.find("input#email-reset").val(),
		password: form.find("input#password-reset").val(),
		password_confirmation: form.find("input#password-reset-confirm").val()
	};

	ajax_locked = true;
	$('#reset-password button').addClass('loading');
	ajaxCall('/password/reset', 'POST', params, 'responseResetPassword');
}

function responseResetPassword(data){
	let errors = getErrors(data);
	let errors_container = $("#reset-password").find('.errors-container');

	errors_container.empty();
	$('#reset-password button').removeClass('loading');
	if(isSuccessStatus(data.status)){
		location.reload();
	} else {
		for(let i = 0; i < errors.length; i++){
			displayFormError(errors_container, errors[i]);
		}
	}
}

function ajaxGetExtraits(collectionId) {
    let params = [];
    params['collection_id'] = collectionId;
    params = Object.assign({}, params);
    ajax_locked = true;
    $("#collection-story").fadeOut("fast");
    ajaxCall('/collections/' + collectionId + '/extraits', 'POST', params, 'responseGetExtraits');
}

function responseGetExtraits(data) {
    let errors = getErrors(data);
    if(isSuccessStatus(data.status)){
        const html = JSON.parse(data.responseText).html;
        $('#collection-story .container').html(html).promise().done(function() {
            $("#collection-story").fadeIn("fast");
            $("#collection-story .slider").slick({
                infinite: false,
                slidesToShow: 1,
                dots: true,
                arrows: false,
            });
        });
    } else {
        for(let i = 0; i < errors.length; i++) {
            console.log(errors[i]);
        }
    }
}
