<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExtraitsTables extends Migration
{
    public function up()
    {
        Schema::create('extraits', function (Blueprint $table) {
            createDefaultTableFields($table);
            $table->string('title', 200);
            $table->text('content')->nullable();
            $table->string('author', 50)->nullable();
            $table->boolean('display_homepage')->nullable();
            $table->unsignedInteger('position')->nullable();

            $table->foreignId('collection_id')->nullable()->constrained('collections')->onDelete('set null');
        });

        Schema::create('extrait_slugs', function (Blueprint $table) {
            createDefaultSlugsTableFields($table, 'extrait');
        });

        Schema::create('extrait_revisions', function (Blueprint $table) {
            createDefaultRevisionsTableFields($table, 'extrait');
        });
    }

    public function down()
    {
        $table->dropForeign(['collection_id']);
        $table->dropColumn('collection_id');

        Schema::dropIfExists('extrait_revisions');
        Schema::dropIfExists('extrait_slugs');
        Schema::dropIfExists('extraits');
    }
}
