<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNewsTables extends Migration
{
    public function up()
    {
        Schema::create('news', function (Blueprint $table) {
            // this will create an id, a "published" column, and soft delete and timestamps columns
            createDefaultTableFields($table);
            $table->string('title', 200);
            $table->text('summary')->nullable();
            $table->text('text')->nullable();
            $table->timestamp('posted_at')->nullable();
            $table->unsignedInteger('position')->nullable();
        });
    }

    public function down()
    {
        Schema::dropIfExists('news');
    }
}
