<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserAbstractsTables extends Migration
{
    public function up()
    {
        Schema::create('user_abstracts', function (Blueprint $table) {
            createDefaultTableFields($table);
            $table->string('story_title', 200)->nullable();
            $table->text('literary_form')->nullable();
            $table->text('register');
            $table->text('theme');
            $table->boolean('is_approved')->nullable();
            $table->text('explanatory')->nullable();
        });
    }

    public function down()
    {
        Schema::dropIfExists('user_abstracts');
    }
}
