<?php

return [
    'namespace' => 'App',
    'admin_app_url' => env('ADMIN_DOMAIN', 'admin.' . env('APP_URL')),
    'admin_app_path' => env('ADMIN_PREFIX', ''),
    'auth_login_redirect_path' => env('ADMIN_PREFIX', '').'/homepage/testimonials',
    'locale' => 'fr',
    'fallback_locale' => 'fr',
    'media_library' => [
        'disk' => 'twill_media_library',
        'endpoint_type' => env('MEDIA_LIBRARY_ENDPOINT_TYPE', 'local'),
        'cascade_delete' => env('MEDIA_LIBRARY_CASCADE_DELETE', false),
        'local_path' => env('MEDIA_LIBRARY_LOCAL_PATH', 'uploads'),
        'image_service' => env('MEDIA_LIBRARY_IMAGE_SERVICE', 'A17\Twill\Services\MediaLibrary\Local'),
        'acl' => env('MEDIA_LIBRARY_ACL', 'private'),
        'filesize_limit' => env('MEDIA_LIBRARY_FILESIZE_LIMIT', 2048),
        'allowed_extensions' => ['jpg', 'gif', 'png', 'jpeg'],
        'init_alt_text_from_filename' => true,
        'prefix_uuid_with_local_path' => config('twill.file_library.prefix_uuid_with_local_path', false),
        'translated_form_fields' => false,
    ],
    'file_library' => [
        'disk' => 'twill_file_library',
        'endpoint_type' => env('FILE_LIBRARY_ENDPOINT_TYPE', 'local'),
        'cascade_delete' => env('FILE_LIBRARY_CASCADE_DELETE', false),
        'local_path' => env('FILE_LIBRARY_LOCAL_PATH', 'uploads'),
        'file_service' => env('FILE_LIBRARY_FILE_SERVICE', 'A17\Twill\Services\FileLibrary\Disk'),
        'acl' => env('FILE_LIBRARY_ACL', 'public-read'),
        'filesize_limit' => env('FILE_LIBRARY_FILESIZE_LIMIT', 50),
        'allowed_extensions' => [],
        'prefix_uuid_with_local_path' => false,
    ],
    'block_editor' => [
        'block_single_layout' => 'admin.block', // layout to use when rendering a single block in the editor
        'block_views_path' => 'admin.blocks', // path where a view file per block type is stored
        'use_twill_blocks' => ['text', 'image'],
        'crops' => [
            'image' => [
                'default' => [
                    [
                        'name' => 'default',
                    ],
                ],
            ],
        ],
    ],
];
