<?php

namespace App\ViewModels\Users;

use App\Models\User;
use JsonSerializable;
use Illuminate\Http\Request;
use App\Models\AbstractModel;
use App\ViewModels\ViewModel;
use App\DataTransferObjects\UserData;

class UserViewModel extends ViewModel implements JsonSerializable
{
    protected User $user;

    public function __construct(Request $request)
    {
        $this->user = $request->user();
    }

    public function user() : UserData
    {
        return new UserData($this->user->toDataObjectArray());
    }

    public function jsonSerialize() : array
    {
        return (new UserData($this->user->toDataObjectArray()))->toArray();
    }

    public function literaryFormList() : array
    {
        $literaryFormList = [];
        foreach (AbstractModel::LITERARY_FORM_LIST as $form) {
            $item = [
                'id' => $form,
                'name' => $form,
            ];
            $literaryFormList[] = $item;
        }

        return $literaryFormList;
    }
}
