<?php

namespace App\Services\Proxies;

use Illuminate\Support\Facades\Http;

/**
 * InstallationProxy
 * Class used to update the `\App\Models\Installation`
 * of the current authenticated user
 *
 * Could be added to `\App\Providers\AppServiceProvider`
 * to be accessible everywhere withtout being initialized
 * each time
 */
class InstallationProxy
{
    /**
     * Make a new request to update installation.
     *
     * @param string $installationId
     * @param string $access_token
     *
     * @return \Illuminate\Http\Client\Response
     */
    public function redirectToUpdateInstall(string $installationId, string $access_token)
    {
        $url = route('api.installations.update', ['uuid' => $installationId]);

        return Http::withHeaders([
            'Content-Type' => 'application/json',
            'accept' => 'application/json',
            'Authorization' => 'Bearer ' . $access_token,
        ])->put($url);
    }
}
