<?php

namespace App\Responses\Responsables;

use League\Fractal\Scope;
use League\Fractal\Manager;
use App\Serializers\CustomArraySerializer;
use League\Fractal\Resource\ResourceInterface;

class ResponseWithManager extends Response
{
    /**
     * Fractal resource manager
     */
    protected \League\Fractal\Manager $manager;

    protected function initialize() : void
    {
        $this->manager = new Manager();
        $this->initManager();
    }

    /**
     * Create a new manager and update it
     *
     * @return void
     */
    private function initManager()
    {
        if (request()->input('include')) {
            $this->manager->parseIncludes(request()->input('include'));
        }

        $this->manager->setSerializer(new CustomArraySerializer());
    }

    /**
     * Call createData method of the manager
     *
     * @param \League\Fractal\Resource\ResourceInterface $resource
     * @param null|string $scopeIdentifier
     * @param null|\League\Fractal\Scope $parentScopeInstance
     *
     * @return \League\Fractal\Scope
     */
    protected function createData(ResourceInterface $resource, string $scopeIdentifier = null, Scope $parentScopeInstance = null)
    {
        return $this->manager->createData($resource, $scopeIdentifier, $parentScopeInstance);
    }
}
