<?php

namespace App\Responses\Responsables;

use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Contracts\Support\Responsable;

abstract class Response implements Responsable
{
    /**
     * Constant representing a successfully sent reminder.
     *
     * @var bool
     */
    const AS_COLLECTION = true;

    /**
     * @var mixed
     */
    protected $data;

    protected bool $as_collection = false;

    protected ?\Illuminate\Http\Request $request = null;

    /**
     * @param mixed  $data
     * @param boolean $as_collection
     */
    final public function __construct($data, $as_collection = false)
    {
        $this->data = $data;
        $this->as_collection = $as_collection;
        $this->initialize();
    }

    abstract protected function initialize() : void;

    /**
     * Create a response that returns JSON data.
     *
     * @param mixed $collection
     *
     * @throws \BadMethodCallException
     *
     * @return \Illuminate\Http\Response|array
     */
    public function toJsonCollectionResponse($collection)
    {
        throw new \BadMethodCallException(get_string('errors.exceptions.bad_method', ['method' => __METHOD__]));
    }

    /**
     * Create a response that returns JSON data.
     *
     * @param mixed $item
     *
     * @throws \BadMethodCallException
     *
     * @return \Illuminate\Http\Response|array
     */
    public function toJsonResponse($item)
    {
        throw new \BadMethodCallException(get_string('errors.exceptions.bad_method', ['method' => __METHOD__]));
    }

    /**
     * Create a response that returns HTML data.
     *
     * @param mixed $data
     *
     * @throws \BadMethodCallException
     *
     * @return \Illuminate\Http\Response
     */
    public function toHtmlResponse($data)
    {
        throw new \BadMethodCallException(get_string('errors.exceptions.bad_method', ['method' => __METHOD__]));
    }

    /**
     * Create an HTTP response that represents the object.
     *
     * @param  \Illuminate\Http\Request  $request
     *
     * @throws \Throwable
     *
     * @return \Illuminate\Http\Response|array
     */
    public function toResponse($request)
    {
        $this->request = $request;
        if ($request->wantsJson()) {
            if ($this->isCollection()) {
                return $this->toJsonCollectionResponse($this->data);
            }

            return $this->toJsonResponse($this->data);
        }

        return $this->toHtmlResponse($this->data);
    }

    /**
     * Determine if response should return a collection.
     *
     * @return boolean
     */
    public function isCollection()
    {
        return $this->as_collection;
    }

    /**
     * Get response data
     *
     * @param mixed $data
     * @param Request $parentRequest
     * @param bool $asColllection
     *
     * @return \Illuminate\Http\Response|array
     */
    public static function data($data, Request $parentRequest, bool $asColllection = false)
    {
        $request = $parentRequest->duplicate();
        $request->headers->set('Accept', 'application/json');

        return (new static($data, $asColllection))->toResponse($request);
    }
}
