<?php
namespace App\Notifications;

use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Auth\Notifications\VerifyEmail as VerifyEmailBase;

class VerifyEmail extends VerifyEmailBase
{
    /**
     * Build the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     *
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        if (static::$toMailCallback !== null) {
            return call_user_func(static::$toMailCallback, $notifiable);
        }

        $url = $this->verificationUrl($notifiable);

        return (new MailMessage)
            ->subject("Stencil : Vérification d'adresse e-mail")
            ->markdown('emails.verify', ['url' => $url]);
    }
}
