<?php
namespace App\Notifications;

use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;

class VerifyChapterFourEmail extends VerifyEmail
{
    /**
     * Build the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     *
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        if (static::$toMailCallback !== null) {
            return call_user_func(static::$toMailCallback, $notifiable);
        }

        $url = $this->verificationUrl($notifiable);

        return (new MailMessage)
            ->subject('Stencil : Validation de la quatrième étape')
            ->markdown('emails.verify-chapter-4', ['url' => $url]);
    }
}
