<?php

namespace App\Models;

use A17\Twill\Models\Model;
use A17\Twill\Models\Behaviors\Sortable;
use A17\Twill\Models\Behaviors\HasBlocks;
use A17\Twill\Models\Behaviors\HasMedias;
use A17\Twill\Models\Behaviors\HasPosition;

class Testimonial extends Model implements Sortable
{
    use HasBlocks;
    use HasMedias;
    use HasPosition;

    /** @var array */
    protected $fillable = [
        'published',
        'title',
        'content',
        'author',
        'display_homepage',
        'position',
        'collection_id',
    ];
    
    public array $mediasParams = [
        'cover' => [
            'default' => [
                [
                    'name' => 'default',
                ],
            ],
        ],
    ];
}
