<?php
namespace App\Models\Presenters;

class UserManuscriptPresenter
{
    protected mixed $entity;

    // This is to store the original model instance

    /**
     * @param  mixed $entity
     */
    public function __construct($entity)
    {
        $this->entity = $entity;
    }

    /**
     * @param  mixed $property
     */
    public function __get($property) : mixed
    {
        if (method_exists($this, $property)) {
            return $this->{$property}();
        }

        return $this->entity->{$property};
    }

    public function fullname() : String
    {
        return $this->entity->user->first_name . ' ' . $this->entity->user->last_name;
    }

    public function email() : String
    {
        return $this->entity->user->email;
    }

    public function status() : String
    {
        if (! $this->entity->is_approved) {
            return 'Pending';
        }

        return $this->entity->is_approved === 1 ? 'Validated' : 'Refused';
    }
}
