<?php

namespace App\Models;

use A17\Twill\Models\Model;
use A17\Twill\Models\Behaviors\HasFiles;
use A17\Twill\Models\Behaviors\Sortable;
use A17\Twill\Models\Behaviors\HasBlocks;
use A17\Twill\Models\Behaviors\HasMedias;
use A17\Twill\Models\Behaviors\HasPosition;

class News extends Model implements Sortable
{
    use HasBlocks;
    use HasMedias;
    use HasFiles;
    use HasPosition;

    /** @var array */
    protected $fillable = [
        'published',
        'title',
        'summary',
        'text',
        'position',
        'posted_at',
    ];
    
    public array $mediasParams = [
        'cover' => [
            'default' => [
                [
                    'name' => 'default',
                    'ratio' => 16 / 9,
                ],
            ],
        ],
    ];
}
