<?php

namespace App\Models;

use A17\Twill\Models\Model;
use A17\Twill\Models\Behaviors\Sortable;
use A17\Twill\Models\Behaviors\HasBlocks;
use A17\Twill\Models\Behaviors\HasMedias;
use A17\Twill\Models\Behaviors\HasPosition;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Collection extends Model implements Sortable
{
    use HasBlocks;
    use HasMedias;
    use HasPosition;

    /** @var array */
    protected $fillable = [
        'published',
        'title',
        'summary',
        'content',
        'author',
        'display_homepage',
        'position',
    ];
    
    public array $mediasParams = [
        'logo' => [
            'default' => [
                [
                    'name' => 'default',
                    'ratio' => 16 / 9,
                ],
            ],
        ],
    ];

    public function testimonials() : HasMany
    {
        return $this->hasMany(Testimonial::class);
    }

    public function extraits() : HasMany
    {
        return $this->hasMany(Extrait::class);
    }
}
