<?php

namespace App\Http\Requests\Admin;

use A17\Twill\Http\Requests\Admin\Request;

class UserAbstractRequest extends Request
{
    public function rulesForCreate() : array
    {
        return [
            'story_title' => ['required', 'string', 'max:191'],
            'literary_form' => ['required', 'string', 'max:191'],
            'register' => ['nullable', 'string', 'max:191'],
            'theme' => ['nullable', 'string', 'max:191'],
            'text' => ['string', 'max:450', 'nullable'],
        ];
    }

    public function rulesForUpdate() : array
    {
        return [
            'story_title' => ['required', 'string', 'max:191'],
            'literary_form' => ['required', 'string', 'max:191'],
            'register' => ['nullable', 'string', 'max:191'],
            'theme' => ['nullable', 'string', 'max:191'],
            'is_approved' => ['required', 'boolean'],
            'explanatory' => ['required', 'string', 'max:191'],
        ];
    }
}
