<?php

namespace App\Http\Controllers\Web;

use Illuminate\Http\Request;
use Illuminate\Contracts\View\View;
use App\Http\Controllers\Controller;

use App\Repositories\NewsRepository;
use App\Repositories\CollectionRepository;
use App\Repositories\TestimonialRepository;

class HomeViewAction extends Controller
{
    protected TestimonialRepository $testimonialRepository;

    protected CollectionRepository $collectionRepository;

    protected NewsRepository $newsRepository;

    public function __construct(
        TestimonialRepository $testimonialRepository,
        CollectionRepository $collectionRepository,
        NewsRepository $newsRepository
    ) {
        $this->testimonialRepository = $testimonialRepository;
        $this->collectionRepository = $collectionRepository;
        $this->newsRepository =$newsRepository;
    }

    public function __invoke(Request $request) : View
    {
        return view('web.pages.index', [
            'testimonies' => $this->testimonialRepository->getHomeTestimonies(),
            'collections' => $this->collectionRepository->getHomeCollections(),
            'newsList' => $this->newsRepository->getHomeNews(),
        ]);
    }

    public function about() : View
    {
        return view('web.pages.about.index');
    }

    public function ourValues() : View
    {
        return view('web.pages.our_values.index');
    }
}
