<?php

namespace App\Http\Controllers\Web;

use App\Models\Collection;
use Illuminate\Http\JsonResponse;
use Illuminate\Contracts\View\View;

use App\Http\Controllers\Controller;
use App\Repositories\ExtraitRepository;
use App\Repositories\CollectionRepository;

class CollectionController extends Controller
{
    protected ExtraitRepository $extraitRepository;

    protected CollectionRepository $collectionRepository;

    public function __construct(ExtraitRepository $extraitRepository, CollectionRepository $collectionRepository)
    {
        $this->extraitRepository = $extraitRepository;
        $this->collectionRepository = $collectionRepository;
    }

    public function index() : View
    {
        $collections = $this->collectionRepository->getAll();

        return view('web.pages.collections.index', [
            'currentCollectionId' => count($collections) > 0 ? $collections[0]->id : 0,
            'collections' => $collections,
            'extraits' => count($collections) > 0 ? $collections[0]->extraits : [],
        ]);
    }

    public function show(Collection $collection) : View
    {
        return view('web.pages.collections.show', [
            'currentCollectionId' => $collection->id,
            'collections' => $this->collectionRepository->getAll(),
            'extraits' => $collection->extraits,
        ]);
    }

    public function getExtraits(Collection $collection) : JsonResponse
    {
        $html = view('web.partials.collections.story', ['extraits' => $collection->extraits])->render();

        return response()->json(['html' => $html]);
    }
}
