<?php

namespace App\Http\Controllers\Admin;

use A17\Twill\Http\Controllers\Admin\ModuleController;

class UserManuscriptController extends ModuleController
{
    protected $moduleName = 'userManuscripts';
    
    protected $indexOptions = [
        'permalink' => false,
    ];
    
    protected $titleColumnKey = 'title';

    protected $indexColumns = [
        'title' => [
            'title' => 'Titre',
            'field' => 'title',
        ],
        'user_fullname' => [ // presenter column
            'title' => "Nom d'utilisateur",
            'field' => 'fullname',
            'present' => true,
        ],
        'user_email' => [ // presenter column
            'title' => 'E-mail',
            'field' => 'email',
            'present' => true,
        ],
        'is_approved' => [ // field column
            'title' => 'Statut',
            'field' => 'status',
            'present' => true,
        ],
    ];
}
