<?php

namespace App\Http\Controllers\Admin;

use A17\Twill\Http\Controllers\Admin\ModuleController;

class UserAbstractController extends ModuleController
{
    protected $moduleName = 'userAbstracts';
    
    protected $indexOptions = [
        'permalink' => false,
    ];

    protected $titleColumnKey = 'story_title';

    protected $indexColumns = [
        'user_fullname' => [ // presenter column
            'title' => "Nom d'utilisateur",
            'field' => 'fullname',
            'present' => true,
        ],
        'user_email' => [ // presenter column
            'title' => 'E-mail',
            'field' => 'email',
            'present' => true,
        ],
        'story_title' => [ // field column
            'title' => "Titre de l'histoire",
            'field' => 'story_title',
        ],
        'is_approved' => [ // field column
            'title' => 'Statut',
            'field' => 'status',
            'present' => true,
        ],
    ];
}
