<?php

namespace App\Http\Controllers\Admin;

use A17\Twill\Http\Controllers\Admin\ModuleController;

class RegisteredUserController extends ModuleController
{
    protected $moduleName = 'registeredUsers';

    protected $titleColumnKey = 'email';
    
    protected $indexOptions = [
        'permalink' => false,
        'publish' => false,
        'bulkEdit' => false,
        'create' => false,
    ];

    protected $indexColumns = [
        'first_name' => [
            'title' => 'Prénom',
            'field' => 'first_name',
            'sort' => true,
        ],
        'last_name' => [
            'title' => 'Nom de famille',
            'field' => 'last_name',
            'sort' => true,
        ],
        'author_name' => [
            'title' => "Nom d'auteur",
            'field' => 'author_name',
            'sort' => true,
        ],
        'birthdate' => [
            'title' => 'Date de naissance',
            'field' => 'birth_date',
        ],
        'email' => [
            'title' => 'E-mail',
            'field' => 'email',
        ],
    ];

    protected $browserColumns = [
        'first_name' => [
            'title' => 'Prénom',
            'field' => 'first_name',
            'sort' => true,
        ],
        'last_name' => [
            'title' => 'Nom de famille',
            'field' => 'last_name',
            'sort' => true,
        ],
        'author_name' => [
            'title' => "Nom d'auteur",
            'field' => 'author_name',
            'sort' => true,
        ],
        'birthdate' => [
            'title' => 'Date de naissance',
            'field' => 'birth_date',
        ],
        'email' => [
            'title' => 'E-mail',
            'field' => 'email',
        ],
    ];
}
