<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Repositories\CollectionRepository;
use Illuminate\Contracts\Foundation\Application;
use A17\Twill\Http\Controllers\Admin\ModuleController;

class ExtraitController extends ModuleController
{
    protected CollectionRepository $colletionRepository;

    protected $moduleName = 'extraits';

    protected $indexOptions = [
        'permalink' => false,
    ];

    public function __construct(Application $app, Request $request, CollectionRepository $colletionRepository)
    {
        parent::__construct($app, $request);

        $this->colletionRepository = $colletionRepository;
    }

    protected function formData($request) : array
    {
        return [
            'collections' => $this->colletionRepository->getAll(),
        ];
    }
}
