<?php

namespace App\DataTransferObjects;

use Carbon\Carbon;
use Spatie\DataTransferObject\DataTransferObject;

/**
 * @method static static immutable(array $parameters)
 */
class UserData extends DataTransferObject
{
    public int $id;

    public string $firstName;

    public string $lastName;

    public string $email;

    public string $authorName;

    public string $birthDate;

    public ?string $description = null;

    public string $step;

    public ?UserAbstractData $userAbstract = null;

    public ?UserManuscriptData $userManuscript = null;

    public ?UserParentsContactData $userParentsContact = null;
    
    public function fullname() : string
    {
        return $this->firstName . ' ' . $this->lastName;
    }

    public function age() : int
    {
        /* @phpstan-ignore-next-line */
        return Carbon::createFromFormat('d/m/Y', $this->birthDate)->age;
    }
}
