<?php

use PhpCsFixer\Finder;
use PhpCsFixer\Config;
use Symfony\CS\FixerInterface;

$finder = Finder::create()
    ->notPath('bootstrap/cache')
    ->notPath('storage')
    ->notPath('vendor')
    ->notPath('node_modules')
    ->in(__DIR__)
    ->name('*.php')
    ->notName('*.blade.php')
    ->notName('_ide_helper*')
    ->ignoreDotFiles(true)
    ->ignoreVCS(true);

$rules = [
    '@PSR2' => true,
    'array_syntax' => ['syntax' => 'short'],
    'blank_line_before_statement' => true,
    'class_attributes_separation' => true,
    'multiline_whitespace_before_semicolons' => false,
    'echo_tag_syntax' => false,
    'no_unused_imports' => true,
    'not_operator_with_successor_space' => true,
    'no_useless_else' => true,
    'ordered_imports' => [
        'sort_algorithm' => 'length',
    ],
    'phpdoc_add_missing_param_annotation' => ['only_untyped' => false],
    'phpdoc_indent' => true,
    'phpdoc_no_package' => true,
    'phpdoc_order' => true,
    'phpdoc_separation' => true,
    'phpdoc_single_line_var_spacing' => true,
    'phpdoc_trim' => true,
    'phpdoc_var_without_name' => true,
    'phpdoc_to_comment' => true,
    'return_type_declaration' => ['space_before' => 'one'],
    'single_quote' => true,
    'ternary_operator_spaces' => true,
    'trailing_comma_in_multiline' => true,
    'trim_array_spaces' => true,
];

return (new Config)
    ->setRules($rules)
    ->setFinder($finder)
    ->setUsingCache(true);
